#include <iostream>
#include <stack>
#include <vector>
#include <cmath>
#include <utility>
#include <map>
#include <algorithm>

using namespace std;

int nadji_rastojanje_ako_je_k_poz(int tr_x, int tr_y, int x2, int y2){
	int x_presecne_tacke = (tr_y - y2 + x2);
	return x_presecne_tacke - tr_x;
}
int nadji_rastojanje_ako_je_k_neg(int tr_x, int tr_y, int x2, int y2){
	int x_presecne_tacke = (x2 + y2 - tr_y);
	return tr_x - x_presecne_tacke;
//	return x_presecne_tacke;
}
void prvi_veci_sa_desne(vector<pair<int,int> >& poz_xy, map<int, pair<int, int> >& poz_pvd, int n){
	stack<int> stek;
	for(int i = 0; i < n; i++){
		while(!stek.empty() and poz_xy[i].second >= poz_xy[stek.top()].second){
			int j = stek.top();
			poz_pvd[ poz_xy[j].first ] = {poz_xy[i].first, poz_xy[i].second};
			stek.pop();
		}
		stek.push(i);
	}
}
void prvi_veci_sa_leve(vector<pair<int,int> >& poz_xy, map<int, pair<int, int> >& poz_pvl, int n){
	stack<int> stek;
	for(pair<int,int> p : poz_xy){
    	poz_pvl[p.first] = {-1, -1};
	}
	for(int i = n-1; i >= 0; i--){
		while(!stek.empty() and poz_xy[i].second >= poz_xy[stek.top()].second){
			int j = stek.top();
			poz_pvl[ poz_xy[j].first ] = {poz_xy[i].first, poz_xy[i].second};
			stek.pop();
		}
		stek.push(i);
	}
}

int main(){
	int n;
	cin >> n;
	vector<pair<int, int> > poz_xy(n);
	vector<int> poz_x(n);
	for(int i = 0; i < n; i++){
		cin >> poz_x[i];
		poz_xy[i].first = poz_x[i];
	}

	vector<int> poz_y(n);
	for(int i = 0; i < n; i++){
		cin >> poz_y[i];
		poz_xy[i].second = poz_y[i];
	}

	sort(poz_xy.begin(), poz_xy.end());
	map<int, pair<int,int> > poz_pvd;
	for(pair<int,int> p : poz_xy){
    	poz_pvd[p.first] = {-1, -1};
	}
	// cout << "DA" << endl;
	prvi_veci_sa_desne(poz_xy, poz_pvd, n);

	map<int, pair<int,int> > poz_pvl;
	prvi_veci_sa_leve(poz_xy, poz_pvl, n);

//	for(int i = 0; i < n; i++){
//		cout << i << " " << poz_pvl[i] << " " << poz_pvd[i] << endl;
//	}
//
	for(int i = 0; i < n; i++){
		int x = poz_x[i];
		int y = poz_y[i];
		if(poz_pvd[x].first == -1 and poz_pvl[x].first == -1){
			cout << -1 << '\n';
		}
		else if(poz_pvd[x].first == -1){
			cout << nadji_rastojanje_ako_je_k_neg(poz_x[i], poz_y[i], poz_pvl[x].first, poz_pvl[x].second) << '\n';
		}
		else if(poz_pvl[x].first == -1){
//			cout << " da " << poz_x[i] << " " << poz_y[i] << " " << " " << poz_x[poz_pvd[i]] << " " << poz_y[poz_pvd[i]] << " ";
			cout << nadji_rastojanje_ako_je_k_poz(poz_x[i], poz_y[i], poz_pvd[x].first, poz_pvd[x].second) << '\n';
		}
		else if(abs(poz_pvd[x].first - poz_x[i]) <= abs(poz_x[i] - poz_pvl[x].first)){
			cout << nadji_rastojanje_ako_je_k_poz(poz_x[i], poz_y[i], poz_pvd[x].first, poz_pvd[x].second) << '\n';
		}
		else if(abs(poz_pvd[x].first- poz_x[i]) > abs(poz_x[i] - poz_pvl[x].first)){
			cout << nadji_rastojanje_ako_je_k_neg(poz_x[i], poz_y[i], poz_pvl[x].first, poz_pvl[x].second) << '\n';
		}
		else{
			cout << -1 << '\n';
		}
	}

	return 0;
}